/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.panel.impl;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.client.gui.stats.panel.ActionBarPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.MenuBarPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatFiltersPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatsTabPanel;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.MenuBarPanelProxyImpl;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.StatFiltersPanelProxyImpl;
import io.github.thecsdev.betterstats.client.gui.stats.panel.impl.StatsTabPanelProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsPanel
extends BSComponentPanel {
    protected final BetterStatsPanelProxy proxy;
    @Nullable
    protected MenuBarPanel panel_menu;
    @Nullable
    protected StatFiltersPanel panel_filters;
    @Nullable
    protected ActionBarPanel panel_actionBar;
    @Nullable
    protected StatsTabPanel panel_stats;

    public BetterStatsPanel(int x, int y, int width, int height, BetterStatsPanelProxy proxy) {
        super(x, y, Math.max(width, 100), Math.max(height, 100));
        this.outlineColor = 0;
        this.backgroundColor = 0;
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final void refreshStatsTab() {
        if (this.panel_stats != null) {
            this.panel_stats.refresh();
        }
    }

    @ApiStatus.Internal
    public final double getStatsTabVerticalScrollAmount() {
        return this.panel_stats != null ? this.panel_stats.getVerticalScrollBarValue() : 0.0;
    }

    protected final void init() {
        int gap = 4;
        BetterStatsConfig config = BetterStats.getInstance().getConfig();
        int rootX = this.getWidth() / 18;
        int rootY = 0;
        int rootW = this.getWidth() - this.getWidth() / 9;
        int rootH = this.getHeight() - 4;
        if (config.centeredStatsPanel) {
            rootH -= 4;
            rootY = 4;
        }
        if (config.wideStatsPanel) {
            rootX = 0;
            rootW = this.getWidth();
            rootY = 0;
            rootH = this.getHeight();
        }
        TPanelElement root = new TPanelElement(rootX, rootY, rootW, rootH);
        root.setScrollFlags(0);
        root.setScrollPadding(0);
        root.setBackgroundColor(0);
        root.setOutlineColor(0);
        this.addChild((TElement)root, false);
        this.panel_menu = new MenuBarPanel(0, 0, root.getWidth(), new MenuBarPanelProxyImpl(this));
        root.addChild((TElement)this.panel_menu, true);
        this.panel_filters = new StatFiltersPanel(0, 19, root.getWidth() / 3 - 4, root.getHeight() - 19 - 26, new StatFiltersPanelProxyImpl(this));
        root.addChild((TElement)this.panel_filters, true);
        this.panel_actionBar = new ActionBarPanel(this.panel_filters.getX(), this.panel_filters.getEndY() + 4, this.panel_filters.getWidth(), new ActionBarPanel.ActionBarPanelProxy(){

            @Override
            public void setSelectedStatsTab(StatsTab statsTab) {
                BetterStatsPanel.this.proxy.setSelectedStatsTab(statsTab);
            }
        });
        root.addChild((TElement)this.panel_actionBar, false);
        this.panel_stats = new StatsTabPanel(this.panel_filters.getEndX() + 4, this.panel_menu.getEndY() + 4, root.getWidth() - (this.panel_filters.getWidth() + 5), root.getHeight() - (this.panel_menu.getHeight() + 4), new StatsTabPanelProxyImpl(this));
        root.addChild((TElement)this.panel_stats, false);
    }

    public static interface BetterStatsPanelProxy {
        public IStatsProvider getStatsProvider();

        public StatsTab getSelectedStatsTab();

        public void setSelectedStatsTab(StatsTab var1);

        public StatFilterSettings getFilterSettings();
    }
}

